<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddIsFromLdapFieldToUsers extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $userFields = [
            [
                'name' => 'is_from_ldap',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'default' => false,
                'weight' => 11,
                'title' => [
                    'fr' => 'Vient du LDAP',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 11,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        ];

        foreach ($userFields as $userField) {
            $this->bridge->contentTypeCreateOrUpdateField('users', $userField['name'], $userField);
        }

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
