<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class CorrectPushNotificationTypeWording extends Migration
{
    public function up(): void
    {
        $notificationTypesTmp = [

            // Someone commented a user content
            [
                'default' => true,
                'event' => 'Inside\Content\Events\CommentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'contentCommented',
                'type' => 'global',
                'condition' => 'parent_type:news,events|author:CURRENT_USER',
                'multiple' => true,
                'language' => false,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.create.comment.content.title',
                    'description' => 'notifications.create.comment.content.description',
                    'icon' => 'comment',
                    'push' => [
                        'subject' => 'notifications.create.comment.mail.subject',
                        'content' => 'notifications.create.comment.content.<content_type>.text',
                    ],
                    'fields' => [
                        'title',
                        'content_type',
                    ],
                ],
            ],

            // Someone answer someone else comment
            [
                'default' => true,
                'event' => 'Inside\Content\Events\CommentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'commentCommented',
                'type' => 'global',
                'condition' => 'author:CURRENT_USER',
                'multiple' => true,
                'language' => false,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.create.comment.comment.title',
                    'description' => 'notifications.create.comment.comment.description',
                    'icon' => 'comment',
                    'push' => [
                        'subject' => 'notifications.create.comment.mail.subject',
                        'content' => 'notifications.create.comment.comment.<content_type>.text',
                    ],
                    'fields' => [
                        'title',
                        'content_type',
                    ],
                    'url' => 'ROOT_RELATION:news,events',
                ],
            ],
        ];

        $notificationTypes = [];

        foreach ($notificationTypesTmp as $notificationType) {
            $notificationTypes[] = new NotificationType(array_merge($notificationType, ['via' => 'push_desktop']));
            $notificationTypes[] = new NotificationType(array_merge($notificationType, ['via' => 'push_mobile']));
        }

        foreach ($notificationTypes as $notificationType) {
            /** @var NotificationType $savedNotificationType */
            $savedNotificationType = NotificationType::query()
                ->where('via', '=', $notificationType->via)
                ->where('event', '=', $notificationType->event)
                ->where('model', '=', $notificationType->model)
                ->where('action', '=', $notificationType->action)
                ->where('condition', '=', $notificationType->condition)
                ->where('profile', '=', $notificationType->profile)
                ->where('type', '=', $notificationType->type)
                ->first();
            $savedNotificationType->data = $notificationType->data;
            $savedNotificationType->save();
        }
    }

    public function down(): void
    {
    }
}
