<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class CorrectEmailNotificationTypeWording extends Migration
{
    public function up(): void
    {
        $notificationTypes = [];

        // Someone commented a user content
        $notificationTypes[] = new NotificationType(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\CommentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'contentCommented',
                'type' => 'global',
                'condition' => 'parent_type:news,events|author:CURRENT_USER',
                'multiple' => true,
                'language' => false,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.create.comment.content.title',
                    'description' => 'notifications.create.comment.content.description',
                    'icon' => 'comment',
                    'text' => 'notifications.create.comment.content.<content_type>.text',
                    'mail' => [
                        'subject' => 'notifications.create.comment.mail.subject',
                        'text' => 'notifications.create.comment.content.<content_type>.mail.text',
                        'buttonText' => 'notifications.comments.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                        'content_type',
                    ],
                ],
            ]
        );

        // Someone answer someone else comment
        $notificationTypes[] = new NotificationType(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\CommentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'commentCommented',
                'type' => 'global',
                'condition' => 'author:CURRENT_USER',
                'multiple' => true,
                'language' => false,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.create.comment.comment.title',
                    'description' => 'notifications.create.comment.comment.description',
                    'icon' => 'comment',
                    'text' => 'notifications.create.comment.comment.<content_type>.text',
                    'mail' => [
                        'subject' => 'notifications.create.comment.mail.subject',
                        'text' => 'notifications.create.comment.comment.<content_type>.mail.text',
                        'buttonText' => 'notifications.comments.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                        'content_type',
                    ],
                    'url' => 'ROOT_RELATION:news,events',
                ],
            ]
        );

        // Likes
        $notificationTypes[] = new NotificationType(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Reaction\Events\ReactionSubscribedEvent',
                'model' => null,
                'type' => 'global',
                'action' => 'like',
                'condition' => 'author:CURRENT_USER|content_type:news,events,comments',
                'multiple' => true,
                'language' => false,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.reaction.like.title',
                    'description' => 'notifications.reaction.like.description',
                    'icon' => 'like',
                    'text' => 'notifications.reaction.<content_type>.like.text',
                    'mail' => [
                        'subject' => 'notifications.reaction.like.mail.subject',
                        'text' => 'notifications.reaction.<content_type>.like.mail.text',
                        'buttonText' => 'notifications.<content_type>.mail.buttonText',
                    ],
                    'fields' => ['title', 'content_type'],
                ],
            ]
        );

        // featured news and events
        $notificationTypes[] = new NotificationType(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\News',
                'action' => 'createOrUpdate',
                'condition' => 'is_featured:1|status:1',
                'multiple' => false,
                'language' => true,
                'profile' => true,
                'type' => 'global',
                'data' => [
                    'title' => 'notifications.create.news.featured.title',
                    'description' => 'notifications.create.news.featured.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.news.featured.text',
                    'mail' => [
                        'subject' => 'notifications.create.news.featured.mail.subject',
                        'text' => 'notifications.create.news.featured.mail.text',
                        'buttonText' => 'notifications.news.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        $notificationTypes[] = new NotificationType(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Events',
                'action' => 'createOrUpdate',
                'condition' => 'is_featured:1|status:1',
                'multiple' => false,
                'language' => true,
                'profile' => true,
                'type' => 'global',
                'data' => [
                    'title' => 'notifications.create.events.featured.title',
                    'description' => 'notifications.create.events.featured.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.events.featured.text',
                    'mail' => [
                        'subject' => 'notifications.create.events.featured.mail.subject',
                        'text' => 'notifications.create.events.featured.mail.text',
                        'buttonText' => 'notifications.events.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        $notificationTypes[] = new NotificationType(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Reaction\Events\ReactionSubscribedEvent',
                'model' => 'Inside\Content\Models\Contents\GroupsPosts',
                'action' => 'like',
                'type' => 'group',
                'condition' => 'author:CURRENT_USER',
                'multiple' => true,
                'language' => false,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.group.like.groups_posts.title',
                    'description' => 'notifications.group.like.groups_posts.description',
                    'icon' => 'group',
                    'text' => 'notifications.group.like.groups_posts.text',
                    'mail' => [
                        'subject' => 'notifications.reaction.like.mail.subject',
                        'text' => 'notifications.group.like.groups_posts.text',
                        'buttonText' => 'notifications.group_posts.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                        'groups' => ['title'],
                        'authors' => ['firstname', 'lastname'],
                        'url' => 'ROOT_RELATION: groups',
                    ],
                ],
            ]
        );

        foreach ($notificationTypes as $notificationType) {
            /** @var NotificationType $savedNotificationType */
            $savedNotificationType = NotificationType::query()
                ->where('via', '=', $notificationType->via)
                ->where('event', '=', $notificationType->event)
                ->where('model', '=', $notificationType->model)
                ->where('action', '=', $notificationType->action)
                ->where('condition', '=', $notificationType->condition)
                ->where('profile', '=', $notificationType->profile)
                ->where('type', '=', $notificationType->type)
                ->first();
            $savedNotificationType->data = $notificationType->data;
            $savedNotificationType->save();
        }
    }

    public function down(): void
    {
    }
}
