<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class AddContents extends Migration
{
    public function up(): void
    {
        $contentMap = [
            'functions' => [
                'Assistant',
                'Commercial',
                'Concessionnaire',
                'Poseur',
                'Autre',
            ],
            'sectors' => [
                'Nord',
                'Rhône Alpes',
                'Sud méditerranée',
                'Sud-Ouest',
                'Centre',
                'Ouest',
                'Ile de France',
                'Alsace',
            ],
        ];

        $bridge = new BridgeContent();
        foreach ($contentMap as $contentType => $contents) {
            foreach ($contents as $content) {
                $bridge->contentUpdate($contentType, [
                    'type' => 'node',
                    'bundle' => $contentType,
                    'title' => $content,
                ]);
            }
        }
    }

    public function down(): void
    {
    }
}
