<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable'      => false,
        'searchable'        => true,
        'global_searchable' => true,
        'aliasable'         => false,
        'permissible'       => false,
        'categorizable'     => false,
        'name'              => 'users',
        'title'             => [
            'fr' => 'Utilisateurs',
        ],
    ],
    'fields'  => [
        [
            'name'                => 'firstname',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Prénom',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'birthday',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Date de naissance',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::TIMESTAMP_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'arrival',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Date d\'arrivée chez Tryba',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::TIMESTAMP_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'company',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 9,
            'title'               => [
                'fr' => 'Société',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 9,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'company',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 9,
            'title'               => [
                'fr' => 'Société',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 9,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'postal_code',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 9,
            'title'               => [
                'fr' => 'Code postal',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 9,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'city',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 9,
            'title'               => [
                'fr' => 'Ville',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 9,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'groups',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Groupes',
            ],
            'description'         => [
                'fr' => 'Le groupe',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['groups'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'image',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 3,
            'title'               => [
                'fr' => 'Image',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator'  => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight'   => 3,
            ],
            'type'                => BridgeContentType::IMAGE_FIELD,
            'settings'            => [
                'uri_scheme'      => 'public',
                'default_image'   => [
                    'uuid'   => '',
                    'alt'    => '',
                    'title'  => '',
                    'width'  => null,
                    'height' => null,
                ],
                'target_type'     => 'file',
                'display_field'   => false,
                'display_default' => false,
                'cardinality'     => 1,
            ],
        ],
        [
            'name'                => 'is_gdpr_compliant',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'GDPR Compliant',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'is_maintenance',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Is a maintenance account ?',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight'   => 2,
            ],
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'lastname',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Nom',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 2,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'functions',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Fonction',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['functions'],
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'sectors',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Secteur',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['sectors'],
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'shortcuts_menus',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Accès rapides',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['shortcuts'],
                'cardinality' => -1,
            ],
        ],
    ],
];
