import SsoAuthLink from './components/auth/SsoAuthLink'

export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-auth': {
    extraComponent: {
      is: SsoAuthLink
    }
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-events': {
    bookmarkEnabled: false
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: 'function',
        data: data => data?.function,
        class: 'function'
      },
      {
        field: { entity: ['title'] },
        data: data => data?.entity?.title,
        class: 'entity'
      }
    ]
  },
  'inside-news': {
    authorEnabled: true,
    bookmarkEnabled: false,
    newsSuggestionEnabled: true
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: ['uuid', 'firstname', 'lastname', 'image', 'function']
      }
    }
  }
}
