import { CONTENTS } from '@inside-ged/constants/default-contents'
const folderContents = CONTENTS()

import { isLogged } from '@inside-auth/middlewares/routes'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'LoginPage',
    path: '/auth',
    meta: { logout: true, requiresAuth: false, middleware: [isLogged] },
    component: () => import('../pages/auth/GoogleLoginPage')
  },
  {
    name: 'InsideLoginPage',
    path: '/connexion',
    alias: '/login',
    component: () => import('@inside-auth/pages/LoginPage'),
    meta: { logout: true, middleware: [isLogged] }
  },
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: {
      disabled: false
    },
    props: {
      suggestFormLink: {
        name: 'FormPage',
        params: {
          slug: 'proposer-une-actualite'
        }
      }
    }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          'archived:eq': 0,
          sort: 'weight:asc'
        },
        fields: [...folderContents.folders.fields]
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
