<?php

namespace Inside\TOUR\Providers;

use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * TOUR Service provider.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__.'/../../config/saml2.php', 'saml2');
            $this->mergeConfigTo(__DIR__.'/../../config/csv.php', 'csv');
            $this->mergeConfigTo(__DIR__.'/../../config/archive.php', 'archive');
        } catch (NotFoundExceptionInterface | ContainerExceptionInterface) {
        }
    }
}
