<?php

namespace Inside\TOUR\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\URL;
use Inside\Content\Models\Contents\Entities;
use Inside\TOUR\Actions\RetrieveEntityImage;
use Laravel\Lumen\Routing\Controller;

class MultiSSOController extends Controller
{
    public function __invoke(): JsonResponse
    {
        $action = new RetrieveEntityImage();

        $entrypoints = Entities::get()->map(fn ($entity) => [
            'title' => $entity->title,
            'image' => $action->retrieve($entity),
            'redirect' => empty($entity->authentication)
                ? URL::to('login')
                : route('saml2.login', ['authenticator' => $entity->authentication]),
        ]);

        return response()->json($entrypoints);
    }
}
