<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

final class ReplayExportNotificationMigration extends Migration
{
    public function up(): void
    {
        DB::table('migrations')->whereIn('migration', [
            '2020_05_12_000000_create_export_notification',
            '2020_09_16_000000_fix_export_notification',
        ])->delete();
        Artisan::call(
            'migrate',
            [
                '--force' => true,
                '--path' => '../inside-content/database/migrations/2020_05_12_000000_create_export_notification.php',
            ]
        );
        Artisan::call(
            'migrate',
            [
                '--force' => true,
                '--path' => '../inside-content/database/migrations/2020_09_16_000000_fix_export_notification.php',
            ]
        );
    }
}
