<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixServiceEntityFromUserRelation extends Migration
{
    use Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bride = new BridgeContentType();

        $bride->contentTypeDeleteField('user', 'user', 'entity');
        $bride->contentTypeDeleteField('user', 'user', 'service');

        $bride->contentTypeCreateField(
            'user',
            'entities',
            [
                'name' => 'entities',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Entité',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 6,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['entities'],
                    'cardinality' => 1,
                ],
            ]
        );

        $bride->contentTypeCreateField(
            'user',
            'services',
            [
                'name' => 'services',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 7,
                'title' => [
                    'fr' => 'Service',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 7,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['services'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ]
        );
    }
}
