<?php

namespace Inside\TOUR\Actions;

use Illuminate\Support\Arr;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Inside\Content\Models\Contents\Entities;

class RetrieveEntityImage
{
    public function retrieve(Entities $entity): string
    {
        if (is_null($entity->image)) {
            return '';
        }

        $public = Storage::disk('public');
        $filename = Arr::last(explode('/', $entity->image));
        $filepath = "{$entity->uuid}/{$filename}";

        if (! $public->exists($filepath)) {
            $public->deleteDirectory($entity->uuid);
            $public->makeDirectory($entity->uuid);

            File::copy(Storage::disk('local')->path($entity->image), $public->path($filepath));
        }

        return $public->url($filepath);
    }
}
