<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/tour-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/tour-back/resources/assets/img/newsletter/bg.jpg',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'sorts' => ['published_at:desc'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#EA9675',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionArrowUrl' => 'vendor/maecia/tour-back/resources/assets/img/newsletter/arrow.png',
                'sectionTextColor' => '#8C162C',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#1D91D3',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionArrowUrl'  => 'vendor/maecia/tour-back/resources/assets/img/newsletter/arrow.png',
                'sectionTextColor' => '#8C162C',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionArrowUrl' => 'vendor/maecia/tour-back/resources/assets/img/newsletter/arrow.png',
                'sectionTextColor' => '#8C162C'
            ],
        ],
        'activities' => [
            'link'        => null, // Pas de links
            'orientation' => 'horizontal',
            'defaultBackgroundColor' => '#FFFFF',
            'defaultValueColor' => '#2c3f50',
            'items' => [
                'comments' => [
                    'callback' => function () {
                        return \Inside\Content\Models\Contents\Comments::count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/tour-back/resources/assets/img/newsletter/comment.png',
                    'titleStrKey' => 'newsletter.comments_statistic',
                ],
                'likes' => [
                    'callback' => function () {
                        return \Inside\Reaction\Models\Reaction::where('type', 'like')->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/tour-back/resources/assets/img/newsletter/like.png',
                    'titleStrKey' => 'newsletter.likes_statistic',
                ],
                'users' => [
                    'callback' => function () {
                        return \Inside\Content\Models\Contents\Users::where('status', true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/tour-back/resources/assets/img/newsletter/user.png',
                    'titleStrKey' => 'newsletter.users_statistic',
                ],
                'news' => [
                    'callback' => function () {
                        return \Inside\Content\Models\Contents\News::where('status', true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/tour-back/resources/assets/img/newsletter/news.png',
                    'titleStrKey' => 'newsletter.contents_statistic',
                ],
            ],
        ]
    ],
    'socials'      => [
        'backgroundColor' => '#11B7DF',
        'links' => [
            'twitter' => [
                'url' => 'https://twitter.com/l4hofficiel',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/l4h-officiel/',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/channel/UChfkZXLQivElq2SUPLPDuPg/videos',
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
