<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class SetUsersFieldsToEditable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            'phone',
            'mobile_phone',
            'biography',
        ];
        foreach ($fields as $field) {
            $bridge->updateFieldOptions('users', $field, [
                'editable' => true,
            ]);
        }
    }
}
