<?php

use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Entities;
use Inside\Content\Models\Contents\Services;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

return [
    'files' => [
        'armonique_habitat' => [
            'path' => env('ARMONIQUE_USERS_PATH', storage_path('../imports/armonique_habitat.csv')),
            'separator' => ',',
            'fields' => [
                'mail' => static fn ($record): string => $record['mail'],
                'name' => static fn ($record): string => $record['prenom'].' '.$record['nom'],
                'firstname' => static fn ($record): string => $record['prenom'],
                'lastname' => static fn ($record): string => $record['nom'],
                'phone' => static fn ($record): string => $record['telbur'],
                'mobile_phone' => static fn ($record): string => $record['telpor'],
                'manager' => static fn ($record): ?string => $record['manager'],
                'services' => static fn ($record): ?string => $record['service'],
                'entities' => static fn ($record): ?string => $record['entities'],
                'function' => static fn ($record): ?string => $record['fonction'],
                'send_mail' => static fn (): bool => false,
                'status' => static fn (): bool => true,
            ],
        ],
    ],
    'postfilter' => static function (Collection $users): array {
        $bridge = new BridgeContent();

        $alreadyImportedUsers = User::all()->pluck('provider_name', 'email');

        $managers = Users::query()
            ->whereIn('email', $users->pluck('manager')->unique())
            ->get()
            ->pluck('uuid', 'email');

        $armonique_habitat = Entities::where('provider_name', 'armorique_habitat')->first();

        $servicesToImport = $users
            ->pluck('service')
            ->filter()
            ->map(fn ($service) => (string) str($service)->lower()->ucfirst())
            ->unique();

        $services = Services::all()->pluck('uuid', 'title');

        $servicesToImport
            ->diff($services->keys())
            ->each(fn ($service) => $services[$service] = $bridge->contentInsert('services', [
                'title' => str($service)->lower()->ucfirst(),
                'status' => 1,
                'author' => Auth::user()?->uuid,
                'langcode' => 'fr',
                'published_at' => Carbon::now(),
            ]));

        return $users->map(function (array $user) use ($managers, $services, $armonique_habitat) {
            $user['manager'] = $managers->get($user['manager'], null);
            $user['nom'] = (string) str($user['nom'])->lower()->title();
            $user['prenom'] = (string) str($user['prenom'])->lower()->title();
            $user['mail'] = (string) str($user['mail'])->lower();
            $user['service'] = $services->get((string) str($user['service'] ?? '')->lower()->ucfirst(), null);
            $user['entities'] = $armonique_habitat->uuid;

            return $user;
        })
            ->reject(fn ($user) => $alreadyImportedUsers->has($user['mail']) && $alreadyImportedUsers->get($user['mail']) !== 'armonique_habitat')
            ->toArray();
    },
];
