import { http } from '@inside-library/helpers/Http'

export const fetchSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'banner',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpaceCategory = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces_categories', {
      fields: [
        'uuid',
        'title',
        'banner',
        'introduction',
        'admin',
        'content_type'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
