import { http } from '@inside-library/helpers/Http'

export const fetchPushImages = async () => {
  try {
    const { data } = await http.get('content/push_images', {
      fields: ['uuid', 'image', 'link', 'admin', 'content_type'],
      filters: { 'status:eq': 1, sort: 'published_at:desc', limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchCardLink = async () => {
  try {
    const { data } = await http.get('content/cards_links', {
      fields: [
        'uuid',
        'title',
        'admin',
        'image',
        'link',
        'link_label',
        'published_at',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        'published_at:lte': 'now()',
        sort: 'published_at:desc',
        limit: 5
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}
