import SpacePage from '../pages/spaces/SpacePage'
import SpaceCategoryPage from '../pages/spaces/SpaceCategoryPage'
import { fetchSpacePage, fetchSpaceCategory } from '../components/spaces/fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: {
      filtersInput: 'selectbox',
      component: 'minimal'
    }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      cardDarkModeEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'MapPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'SpaceCategoryPage',
    path: '/spaces-categories/:slug',
    component: withFetch(SpaceCategoryPage, { size: 'xxl', watch: true })(
      fetchSpaceCategory
    )
  },
  {
    name: 'SpacePage',
    path: '/spaces/:slug/pages',
    component: withFetch(SpacePage, { size: 'xxl' })(fetchSpacePage)
  },
  {
    name: 'ToolsPage',
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    },
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsAutomaticTranslationPage',
    meta: { admin: true, display: true }
  }
]
