export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ],
    dates: {
      LT: 'HH:mm',
      L: 'DD/MM/YYYY',
      LL: 'D MMMM YYYY',
      LLL: 'D MMMM YYYY',
      LLLL: 'dddd D MMMM YYYY',
      l: 'D MMMM YYYY',
      ll: 'D MMMM YYYY',
      lll: 'D MMM YYYY',
      llll: 'D MMMM YYYY'
    }
  },
  'inside-commons': {
    banner: {
      darkMode: false
    }
  },
  'inside-edition': {
    duplicateEnabled: true
  },
  'inside-events': {
    calendarImportEnabled: true,
    liveTranslate: {
      enabled: true
    }
  },
  'inside-ged': {
    liveTranslate: {
      enabled: true
    }
  },
  'inside-layouts': {
    liveTranslateSimplePage: {
      enabled: true
    },
    liveTranslateTabsSpace: {
      enabled: true
    }
  },
  'inside-news': {
    bookmarkEnabled: false,
    categoriesSubscriptionEnabled: true,
    liveTranslate: {
      enabled: true
    },
    minimalDate: true
  },
  'inside-users': {
    shortcuts: {
      max: 5,
      readonlyCount: 3
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'subscriptions', restrictions: [], icon: 'tag' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('../inside-customs/components/users/Card'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          { departments: ['uuid', 'title'] },
          { cities: ['uuid', 'title'] }
        ]
      }
    }
  }
}
