<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldLinkToContentTypeStockPrices extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'stock_prices',
            'link',
            [
                'name' => 'link',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 7,
                'title' => [
                    'en' => 'Link',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                    'settings' => [],
                    'weight' => 7,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
