<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Content\Models\Contents\StockPrices;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

final class InstallStockPrices extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        ContentBlueprints::generateContent('stock_prices');

        $this->call('models:rebuild');

        $stocks = collect([
            'TIKEHAU CAPITAL' => 'TKO.PAR',
        ]);

        $bridge = new BridgeContent();

        $stocks->each(function (string $stockId, string $title) use ($bridge) {
            if (! StockPrices::whereStockId($stockId)->exists()) {
                $bridge->contentInsert('stock_prices', [
                    'title' => $title,
                    'stock_id' => $stockId,
                    'currency' => 'eur',
                ]);
            }
        });
    }
}
