<?php

declare(strict_types=1);

namespace Inside\TIK2\Providers;

use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

final class ServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/alphavantage.php', 'alphavantage');
            $this->mergeConfigTo(__DIR__.'/../../config/ldap_auth.php', 'ldap_auth');
        } catch (NotFoundExceptionInterface | ContainerExceptionInterface) {
        }
    }
}
