<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationSubscriber;

class RemoveNewsCategoriesEmailNotifications extends Migration
{
    public function up(): void
    {
        $types = NotificationType::where('via', 'email')
            ->where('action', 'follow')
            ->where('event', 'Inside\Notify\Events\CustomNotificationEvent')
            ->where('model', "Inside\Content\Models\Contents\News")
            ->pluck('id');

        $types->each(function (int $id) {
            NotificationSubscriber::where('notification_type_id', $id)->delete();
        });
    }
}
