<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;

class UpdateTik2Shortcut extends Migration
{
    public function up(): void
    {
        $toolsTitles = [
            'Human Capital Platform' => 0,
            'Star Compliance' => 1,
            'Whistleblowing' => 2,
            'Support Services' => 3,
            'Egencia' => 4,
        ];

        $tools = Tools::query()
            ->whereIn('title', array_keys($toolsTitles))
            ->pluck('title', 'uuid');

        $bridge = new BridgeContent();

        collect($tools)->each(fn ($title, $uuid) => $bridge->contentUpdate(
            type: 'tools',
            data: [
                'uuid' => $uuid,
                'title' => $title,
                'weight' => $toolsTitles[$title],
            ]
        ));

        $bridgeContentType = new BridgeContentType();

        $defaultTools = [
            ['target_uuid' => Tools::where('title', 'Human Capital Platform')->first()->uuid_host],
            ['target_uuid' => Tools::where('title', 'Star Compliance')->first()->uuid_host],
            ['target_uuid' => Tools::where('title', 'Whistleblowing')->first()->uuid_host],
            ['target_uuid' => Tools::where('title', 'Support Services')->first()->uuid_host],
            ['target_uuid' => Tools::where('title', 'Egencia')->first()->uuid_host],
        ];

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'tools',
            options: [
                'title' => [
                    'en' => 'Quick access'
                ],
                'default' => $defaultTools
            ]
        );

        Users::all()->each(
            fn ($user) => $bridge->updateReferenceFields(
                type: 'users',
                contentUuidHost: $user->uuid_host,
                data: [
                    'tools' => $defaultTools
                ]
            )
        );
    }
}
