<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Content\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('departments');
        $this->migrateContent('grades');
        $this->migrateContent('offices');
        $this->migrateContent('cities');
        $this->migrateContent('companies');
        $this->migrateContent('teams');
        $this->migrateContent('users');
        $this->migrateContent('news_categories');
        $this->migrateContent('news');
        $this->migrateContent('events_categories');
        $this->migrateContent('events');
        $this->migrateContent('folders');
        $this->migrateContent('documents');
        $this->migrateContent('tools_categories');
        $this->migrateContent('tools');
        $this->migrateContent('blocks');
        $this->migrateContent('push_images');
        $this->migrateContent('spaces_categories');
        $this->migrateContent('spaces');
        $this->migrateContent('tabs');
        $this->migrateContent('tabs_pages');

        ContentBlueprints::generateContent('flash_news');

        if (Schema::hasModel('team')) {
            $this->getBridge()?->contentTypeDelete('team');
        }

        $this->finishUp();
    }
}
