<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'news',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'en' => 'News',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'en' => 'Main picture',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'chapo',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'en' => 'Introduction',
            ],
            'description' => [
                'en' => 'The introduction goes up on the news listing pages and is not duplicated in your content',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'en' => 'Content',
            ],
            'description' => [
                'en' => 'Select the different types of paragraphs you want to move up the page',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'news_categories',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 3,
            'title' => [
                'en' => 'News category(ies)',
            ],
            'description' => [
                'en' => 'Sélectionnez la ou les catégorie de cette actualité',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'comments',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'en' => 'Comments',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::COMMENT_FIELD,
            'settings' => [
                'comment_type' => 'comments',
                'cardinality' => 1,
            ],
        ],
    ],
];
