<?php

use Adldap\Models\Entry;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Users;
use Inside\Support\Str;
use Illuminate\Support\Facades\Storage;

return [
    "usernames" => [
        "ldap" => [
            "discover" => env("ADLDAP_LDAP_DISCOVER", "displayname"),
            "authenticate" => env("ADLDAP_LDAP_AUTHENTICATE", "mail"),
        ],
        "eloquent" => env("ADLDAP_ELOQUENT_VALUE", "email"),
    ],
    "discovering_attributes" => "name",
    "sync_attributes" => [
        "email" => "mail",
        "name" => "mail",
        "samaccountname" => "samaccountname",
        "firstname" => "givenname",
        "lastname" => "sn",
        "fullname" => "displayname",
        "phone" => "telephonenumber",
        "mobile_phone" => "mobile",
        "image" => function (Entry $user) {
            $image = $user->getThumbnail();
            if (!$image) {
                return null;
            }

            $fileName = Str::uuid() . ".jpeg";
            $chunkId = Str::random(32);
            $chunkPath = "chunks/$chunkId/$fileName";
            Storage::makeDirectory("chunks/$chunkId");
            Storage::disk("local")->put($chunkPath, $image);

            return $chunkPath;
        },
        "departments" => fn (Entry $user) => reference("departments")
            ->from($user->getAttribute("department")[0])
            ->get(),
        "grades" => fn (Entry $user) => reference("grades")
            ->from($user->getAttribute("extensionattribute5")[0])
            ->get(),
        "offices" => fn (Entry $user) => reference("offices")
            ->from($user->getAttribute("physicaldeliveryofficename")[0])
            ->get(),
        "cities" => fn (Entry $user) => reference("cities")
            ->from($user->getAttribute("l")[0])
            ->get(),
        "companies" => fn (Entry $user) => reference("companies")
            ->from($user->getAttribute("company")[0])
            ->get(),
        "teams" => fn (Entry $user) => reference("teams")
            ->from($user->getAttribute("extensionattribute8")[0])
            ->get(),
        "teams_link" => fn (
            Entry $user
        ) => "https://teams.microsoft.com/l/chat/0/0?users=" .
            $user->getAttribute("samaccountname")[0],
        "manager" => function (
            Entry $user,
            \Inside\Host\Bridge\BridgeContent $bridge
        ) {
            $managerLdapAttributes = $user->getFirstAttribute("manager");
            if (empty($managerLdapAttributes)) {
                return null;
            }

            $managerLdapAttributes = explode(",", $managerLdapAttributes);
            $managerNames = [];
            foreach ($managerLdapAttributes as $managerLdapAttribute) {
                $managerLdapAttribute = explode("=", $managerLdapAttribute);

                if ($managerLdapAttribute[0] !== "CN") {
                    continue;
                }

                $managerNames[] = $managerLdapAttribute[1];
            }

            if (empty($managerNames)) {
                return null;
            }

            $managers = [];

            foreach ($managerNames as $managerName) {
                $manager = Users::where("fullname", $managerName)->first();

                if ($manager) {
                    $managers[] = $manager->uuid;
                }
            }

            if (empty($managers)) {
                return null;
            }

            return $managers;
        },
    ],
];
