import { http } from '@inside-library/helpers/Http'
import get from 'lodash/get'

export default {
  newComer: {
    add: () => ({
      name: 'JobSpace',
      params: { slug: 'ressources-humaines' }
    }),
    delete: () => ({
      name: 'JobSpace',
      params: { slug: 'ressources-humaines' }
    })
  },
  projects: {
    add: ({ data }) => ({
      name: 'ProjectPage',
      params: {
        slug: data.slug[0]
      }
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projectsDocuments: {
    add: async ({ data, fields }) => {
      try {
        const { data: docData } = await http.get('content/projects_documents', {
          fields: ['uuid', { projects: ['uuid', 'title', 'slug'] }],
          filters: { 'uuid:eq': data.uuid }
        })

        return {
          name: 'ProjectPage',
          params: { slug: docData[0].projects.data[0].slug[0] },
          query: {
            folder: fields.projects_folders[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: () => ({
      name: 'ProjectsListingPage'
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  projectsFolders: {
    add: async ({ data }) => {
      const { data: projectsFolders } = await http.get(
        'content/projects_folders',
        {
          fields: ['uuid', { projects: ['uuid', 'title', 'slug'] }],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      return {
        name: 'ProjectPage',
        params: { slug: projectsFolders[0].projects.data[0].slug[0] },
        query: {
          folder: projectsFolders[0].uuid
        }
      }
    },
    delete: () => ({
      name: 'ProjectsListingPage'
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  projectsStatus: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  directions: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projectsNews: {
    add: ({ data }) => ({
      name: 'ProjectNewsPage',
      params: { slug: data.slug[0] }
    })
  },
  jobSpaces: {
    add: ({ data }) => ({
      name: 'JobSpace',
      params: { slug: data.slug[0] }
    })
  },
  groupingPages: {
    add: async ({ fields }) => {
      try {
        const { data } = await http.get('content/job_spaces', {
          fields: ['uuid', 'title', 'slug'],
          filters: { 'uuid:eq': fields.job_spaces[0] }
        })

        const slug = get(data, [0, 'slug', 0])

        return {
          name: 'JobSpace',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/grouping_pages', {
          fields: [
            {
              job_spaces: {
                fields: ['uuid', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        const jobSpaces = get(data, [0, 'job_spaces', 'data', 0, 'slug', 0])

        return {
          name: 'JobSpace',
          params: { slug: jobSpaces }
        }
      } catch (err) {
        return { path: '/' }
      }
    }
  },
  jobPages: {
    add: async ({ data }) => {
      try {
        let { data: jobPage } = await http.get('content/job_pages', {
          fields: ['uuid', 'title', 'slug'],
          filters: { 'uuid:eq': data.uuid, limit: 1 }
        })

        const slug = jobPage[0].slug[0]

        return {
          name: 'JobPage',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        let { data } = await http.get('content/job_pages', {
          fields: [
            {
              grouping_pages: {
                fields: ['uuid', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        let uuidGroupingPage = data[0].grouping_pages.data[0].uuid

        data = await http.get('content/grouping_pages', {
          fields: [
            {
              job_spaces: {
                fields: ['uuid', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidGroupingPage }
        })

        const slug = data.data[0].job_spaces.data[0].slug[0]

        return {
          name: 'JobSpace',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    }
  },
  jobModals: {
    add: async ({ fields }) => {
      try {
        const { data } = await http.get('content/grouping_pages', {
          fields: [
            'uuid',
            {
              job_spaces: {
                fields: ['uuid', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': fields.grouping_pages[0] }
        })

        const slug = get(data, [0, 'job_spaces', 'data', 0, 'slug', 0])

        return {
          name: 'JobSpace',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        let { data } = await http.get('content/job_modals', {
          fields: [
            {
              grouping_pages: {
                fields: ['uuid', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        let uuidGroupingPage = data[0].grouping_pages.data[0].uuid

        data = await http.get('content/grouping_pages', {
          fields: [
            {
              job_spaces: {
                fields: ['uuid', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidGroupingPage }
        })

        const slug = data.data[0].job_spaces.data[0].slug[0]

        return {
          name: 'JobSpace',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    }
  },
  jobLinks: {
    add: async ({ fields }) => {
      try {
        const { data } = await http.get('content/grouping_pages', {
          fields: [
            'uuid',
            {
              job_spaces: {
                fields: ['uuid', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': fields.grouping_pages[0] }
        })

        const slug = get(data, [0, 'job_spaces', 'data', 0, 'slug', 0])

        return {
          name: 'JobSpace',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        let { data } = await http.get('content/job_links', {
          fields: [
            {
              grouping_pages: {
                fields: ['uuid', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        let uuidGroupingPage = data[0].grouping_pages.data[0].uuid

        data = await http.get('content/grouping_pages', {
          fields: [
            {
              job_spaces: {
                fields: ['uuid', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidGroupingPage }
        })

        const slug = data.data[0].job_spaces.data[0].slug[0]

        return {
          name: 'JobSpace',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    }
  },
  toolsMasters: {
    add: ({ data }) => ({
      name: 'ToolsMastersPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'ToolsMastersListingPage'
    })
  },
  tools: {
    add: async ({ data }) => {
      const { data: tools } = await http.get('content/tools', {
        fields: [
          'uuid',
          {
            tools_categories: [
              'uuid',
              'title',
              {
                tools_masters: ['uuid', 'title', 'slug']
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })
      return {
        name: 'ToolsMastersPage',
        params: {
          slug: tools[0].tools_categories.data[0].tools_masters.data[0].slug[0]
        }
      }
    },
    delete: async ({ data }) => {
      const { data: tools } = await http.get('content/tools', {
        fields: [
          'uuid',
          {
            tools_categories: [
              'uuid',
              'title',
              {
                tools_masters: ['uuid', 'title', 'slug']
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })
      return {
        name: 'ToolsMastersPage',
        params: {
          slug: tools[0].tools_categories.data[0].tools_masters.data[0].slug[0]
        }
      }
    }
  },
  toolsCategories: {
    add: async ({ data }) => {
      const { data: toolsCategories } = await http.get(
        'content/tools_categories',
        {
          fields: ['uuid', { tools_masters: ['uuid', 'title', 'slug'] }],
          filters: { 'uuid:eq': data.uuid }
        }
      )
      return {
        name: 'ToolsMastersPage',
        params: { slug: toolsCategories[0].tools_masters.data[0].slug[0] }
      }
    },
    delete: async ({ data }) => {
      const { data: toolsCategories } = await http.get(
        'content/tools_categories',
        {
          fields: ['uuid', { tools_masters: ['uuid', 'title', 'slug'] }],
          filters: { 'uuid:eq': data.uuid }
        }
      )
      return {
        name: 'ToolsMastersPage',
        params: { slug: toolsCategories[0].tools_masters.data[0].slug[0] }
      }
    }
  }
}
