import { http } from '@inside-library/helpers/Http'

export default {
  pos: 1,
  group: 'postLogin',
  fn: async ({ to, router }) => {
    if (to.path === '/espaces') {
      try {
        const { data } = await http.get('content/job_spaces', {
          fields: ['slug'],
          filters: { 'status:eq': 1, limit: 1 }
        })

        router.push({
          name: 'JobSpace',
          params: { slug: data[0].slug[0] }
        })
      } catch (err) {
        throw new Error(err)
      }
    }
  }
}
