export default {
  globals: {
    dates: {
      lll: 'D MMM'
    },
    notificationRedirectionsContentTypes: [
      'job_spaces',
      'news',
      'projects_news'
    ],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'NewsPage',
        params: {
          slug: data.slug[0]
        }
      }),
      projectsNews: async ({ data }) => ({
        name: 'ProjectNewsPage',
        params: {
          slug: data.slug[0]
        }
      }),
      jobSpaces: async ({ data }) => ({
        name: 'JobSpaces',
        params: {
          slug: data.slug[0]
        }
      })
    }
  },
  'inside-forms': {
    extraValidationStatus: [{ key: 'realised', value: 4 }]
  },
  'inside-ged': {
    allowReportPictures: false,
    rootRoute: {
      fr: 'documentation'
    }
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  },
  'inside-news': {
    bookmarkEnabled: false
  },
  'inside-teams': {
    rootRoute: {
      fr: 'forum'
    }
  },
  'inside-customs': {
    templates: {
      fullContent: {
        projectsNews: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        }
      }
    }
  }
}
