import { http } from '@inside-library/helpers/Http'
import { userFields } from '../constants/user-fields'

const fetchMasterTools = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tools_masters', {
      fields: [
        'title',
        'uuid',
        'banner',
        'introduction',
        'slug',
        'admin',
        'content_type'
      ],
      filters: { slug: $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchProjectsNews = async ({ $route }) => {
  try {
    const { data } = await http.get('content/custom', {
      fields: [
        'uuid',
        'content_type',
        {
          news_categories: ['title', 'content_type', 'uuid']
        }
      ],
      filters: { 'slug:eq': $route.path.replace(/\//, '') }
    })

    if (!data.length) {
      return []
    }

    const newsCategoriesUuid = data[0].news_categories.data.map(
      ({ uuid }) => uuid
    )

    return newsCategoriesUuid
  } catch (err) {
    throw new Error(err)
  }
}

const fetchSpace = async ({ $route }) => {
  try {
    const { data: spaceData } = await http.get('content/job_spaces', {
      filters: { 'slug:eq': $route.params.slug },
      fields: [
        'uuid',
        'title',
        'slug',
        'content_type',
        'introduction',
        'banner',
        'admin',
        'new_comers',
        'js_informations',
        { key_contacts: userFields },
        {
          tools: [
            'title',
            'uuid',
            'has_section',
            'link',
            'admin',
            'image',
            'class',
            'content_type'
          ]
        },
        {
          news_categories: {
            fields: ['uuid', 'title']
          }
        }
      ]
    })

    const { data: newComerData } = await http.get('content/new_comer', {
      fields: [...userFields, 'title'],
      filters: {
        'status:eq': 1,
        sort: 'updated_at:desc',
        limit: 3
      }
    })

    return {
      space: spaceData[0],
      new_comer: newComerData
    }
  } catch (err) {
    throw new Error(err)
  }
}

const fetchProject = async ({ $route }) => {
  try {
    const { data: projectData } = await http.get('content/projects', {
      fields: [
        'uuid',
        'title',
        'slug',
        'content_type',
        'admin',
        'banner',
        'project_website',
        'content',
        'team_title',
        { directions: ['uuid', 'title'] },
        { projects_status: ['uuid', 'title', 'color'] },
        { projects_teams: userFields }
      ],
      filters: {
        'status:eq': 1,
        slug: $route.params.slug
      }
    })

    return {
      project: projectData[0]
    }
  } catch (err) {
    throw new Error(err)
  }
}

const fetchJobPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/job_pages', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        {
          grouping_pages: {
            fields: [
              {
                job_spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        }
      ],
      filters: { slug: $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export {
  fetchMasterTools,
  fetchSpace,
  fetchProjectsNews,
  fetchProject,
  fetchJobPage
}
