export default {
  // GED
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  // USERS
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'image',
      'firstname',
      'lastname',
      'function',
      'email',
      'phone',
      'directions',
      'sub_directions',
      'job',
      'office_numbers'
    ]
  },
  // HR
  job_modals: {
    extendedUrl: ['uuid'],
    modalFields: [
      'content',
      'content_type',
      'published_at',
      'title',
      'updated_at',
      'uuid',
      'admin',
      { authors: ['lastname', 'firstname'] }
    ]
  },
  projects_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      { folders: ['title'] },
      { authors: ['lastname', 'firstname'] }
    ]
  },
  groups_documents: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  }
}
