import { withFetch } from 'inside-collection/hocs'

import HrSpacePage from '../pages/HrSpacePage'
import ProjectsListingPage from '../pages/ProjectsListingPage'
import ProjectPage from '../pages/ProjectPage'
import ToolsMastersPage from '../pages/Tools/ToolsMastersPage'
import JobPage from '../pages/JobPage'

import {
  fetchMasterTools,
  fetchSpace,
  fetchProjectsNews,
  fetchProject,
  fetchJobPage
} from '../fetch'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'JobSpace',
    path: '/espaces/:slug',
    component: withFetch(HrSpacePage, { size: 'xxl', watch: true })(fetchSpace)
  },
  {
    name: 'JobPage',
    path: '/page-metier/:slug',
    component: withFetch(JobPage, { size: 'xxl', watch: true })(fetchJobPage)
  },
  {
    name: 'ProjectNewsPage',
    path: '/actualites-projet/:slug',
    component: () => import('../pages/ProjectNewsPage')
  },
  {
    name: 'ToolsMastersListingPage',
    path: '/master-outils',
    component: () => import('../pages/Tools/ToolsMastersListingPage')
  },
  {
    name: 'ToolsMastersPage',
    path: '/outils/:slug',
    component: withFetch(ToolsMastersPage, { size: 'xxl', watch: true })(
      fetchMasterTools
    )
  },
  {
    name: 'ProjectsListingPage',
    component: withFetch(ProjectsListingPage, { size: 'xxl', watch: true })(
      fetchProjectsNews
    ),
    path: '/projets'
  },
  {
    name: 'ProjectPage',
    component: withFetch(ProjectPage, { size: 'xxl', watch: true })(
      fetchProject
    ),
    path: '/projets/:slug'
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  }
]
