<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddNewStatusForm extends Migration
{
    public function up(): void
    {
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdated',
                'type' => 'system',
                'condition' => 'status:4',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data'     => [
                    'text' => 'notifications.form.submission.realized.text',
                    'fields'      => [
                        'title'
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdated',
                'type' => 'system',
                'condition' => 'status:4',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data'     => [
                    'mail'        => [
                        'subject'    => 'notifications.form.submission.realized.email.subject',
                        'text'       => 'notifications.form.submission.realized.email.text',
                        'buttonText' => 'notifications.form.submission.buttonText',
                    ],
                    'fields'      => [
                        'title'
                    ],
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
