<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateNewFieldsForUsers extends migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('users', 'skype', [
                'name' => 'skype',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'editable' => false,
                'weight' => 13,
                'title' => [
                    'fr' => 'Adresse Skype',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 14,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
        ]);
        $bridge->contentTypeCreateOrUpdateField('users', 'office_numbers', [
                'name' => 'office_numbers',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'editable' => false,
                'weight' => 14,
                'title' => [
                    'fr' => 'Numéro de bureau',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 15,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
        ]);
        $bridge->contentTypeCreateOrUpdateField('users', 'sub_directions', [
                'name' => 'sub_directions',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'editable' => false,
                'weight' => 15,
                'title' => [
                    'fr' => 'Sous direction',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 16,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
        ]);

        $bridge->updateFieldOptions('users', 'directions', [
            'title' => [
                'fr' => 'DGA'
            ],
        ]);
        $bridge->updateFieldOptions('users', 'phone', ['editable' => false]);
    }

    public function down(): void
    {
    }
}
