<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'searchable'        => true,
        'global_searchable' => true,
        'aliasable'         => false,
        'permissible'       => true,
        'categorizable'     => true,
        'name'              => 'projects_folders',
        'listing_type'      => 'taxo',
        'title'             => [
            'fr' => 'Dossier de projet'
        ],
    ],
    'fields'  => [
        [
            'name' => 'projects',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Projet lié',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => 'projects',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'folders',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Dossier parent',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'folders',
                'cardinality' => -1,
            ],
        ],
    ],
];
