<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'searchable'        => true,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'name'              => 'job_links',
        'title'             => [
            'fr' => 'Lien métier'
        ],
    ],
    'fields'  => [
        [
            'name' => 'link',
            'type' => BridgeContentType::LINK_FIELD,
            'searchable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Lien',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'title' => 0,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'type' => BridgeContentType::INTEGER_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Ordre d\'affichage',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er'
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'grouping_pages',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Regroupement de pages'
            ],
            'description' => [
                'fr' => 'Choix du groupe de page dans lequel cette page doit apparaître',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'group_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'grouping_pages',
                'cardinality' => -1,
            ],
        ],
    ],
];
