<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddMobilePhoneFieldForUsers extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            options: [
                'name' => 'mobile_phone',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Mobile',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 5,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            fieldName: 'mobile_phone',
        );
    }
}
