<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

final class RemoveSkypeFieldInUsers extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        if (
            InsideSchema::hasModel(modelName: 'users') &&
            InsideSchema::hasField(modelName: 'users', fieldName: 'skype')
        ) {
            $bridgeContentType->contentTypeDeleteField(entityType: 'user', type: 'user', fieldName: 'skype');
            Artisan::call('models:rebuild');
        }
    }
}
