<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddNewsCategoriesFieldOnCustom extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'projects', 'news_categories');

        $bridge->contentTypeCreateOrUpdateField(
            'custom',
            'news_categories',
            [
                'name' => 'news_categories',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'weight' => 1,
                'title' => [
                    'fr' => 'Catégorie d\'actualité'
                ],
                'description' => [
                    'fr' => 'Vous pouvez mettre plusieurs catégories pour une même actualité',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 2,
                    'group' => 'group_options',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'news_categories',
                    'cardinality' => -1,
                ],
            ],
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
