<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateFieldTeamTitleForProject extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'team_title',
            [
                'name' => 'team_title',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'editable' => false,
                'search_result_field' => false,
                'required' => true,
                'weight' => 6,
                'title' => [
                    'fr' => 'Lien',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 7,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            6
        );
    }

    public function down(): void
    {
    }
}
