<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class AddUsersFullname extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasField('users', 'fullname')) {
            return;
        }

        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateField(
            'user',
            'fullname',
            [
                'name' => 'fullname',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Nom complet',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            null,
            'user'
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
