<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateProjectsContentType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'projects', 'key_dates');
        $bridge->contentTypeCreateOrUpdateField(
            'projects',
            'content',
            [
                'name' => 'content',
                'searchable' => true,
                'translatable' => false,
                'default' => null,
                'search_result_field' => false,
                'required' => true,
                'weight' => 8,
                'title' => [
                    'fr' => 'Contenu',
                ],
                'description' => [
                    'fr' => ''
                ],
                'widget' => [
                    'type' => BridgeContentType::SECTION_WIDGET,
                    'settings' => [
                        'title' => 'Paragraph',
                        'title_plural' => 'Paragraphs',
                        'edit_mode' => 'closed',
                        'add_mode' => 'dropdown',
                        'form_display_mode' => 'default',
                        'default_paragraph_type' => '_none',
                    ],
                    'weight' => 9,
                ],
                'type' => BridgeContentType::SECTION_FIELD,
                'settings' => [
                    'target_type' => ['text', 'image', 'text_with_image', 'file', 'slider', 'accordion', 'call_to_action', 'video', 'html', 'map', 'user_cards'],
                    'cardinality' => -1,
                ],
            ]
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
