<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => false,
        'searchable'        => false,
        'global_searchable' => false,
        'aliasable'         => false,
        'permissible'       => true,
        'categorizable'     => true,
        'name'              => 'events_categories',
        'listing_type'      => 'taxo',
        'title'             => [
            'fr' => 'Catégorie d\'événement'
        ],
    ],
    'fields'  => [
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => false,
            'default' => '007987',
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Couleur'
            ],
            'description' => [
                'fr' => 'Vous devez indiquer une couleur commençant par # (exemple : #ffffff)'
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
