<?php

use Inside\Host\Bridge\BridgeContent;
use Inside\Support\Str;

if (! function_exists('get_entity_reference')) {
    function get_entity_reference(BridgeContent $bridge, string $contentType, ?string $value): ?string
    {
        if (empty($value)) {
            return null;
        }

        $existing = type_to_class($contentType)::where('title', $value)->first()?->uuid;

        return $existing ?? $bridge->contentInsert($contentType, ['title' => $value]);
    }
}

if (! function_exists('get_direction')) {
    function get_direction(mixed $user, int $position): ?string
    {
        $directions = trim($user->department);

        if (empty($directions) || ! Str::contains($directions, '|')) {
            return null;
        }

        $exploded = explode('|', $directions);
        if (count($exploded) !== 2) {
            return null;
        }

        $subDirection = trim($exploded[$position]);

        if (empty($subDirection) || $subDirection === '-') {
            return null;
        }

        return $subDirection;
    }
}

return [
    'postfilter' => fn ($users) => $users->reject(fn ($user) => !str($user->onPremisesDistinguishedName ?? '')->contains('OU=Syctom,OU=Utilisateurs,DC=syctom,DC=intra')),
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'status' => fn () => true,
        'firstname' => 'givenName',
        'lastname' => 'surname',
        'fullname' => 'displayName',
        'function' => 'jobTitle',
        'phone' => 'telephoneNumber',
        'mobile_phone' => 'mobile',
        'office_numbers' => 'officeLocation',
        'directions' => fn (mixed $user, BridgeContent $bridge) => get_entity_reference($bridge, 'directions', get_direction($user, 0)),
        'sub_directions' => fn (mixed $user) => get_direction($user, 1)
    ],
];
