import DelegatesSpacePage from '../pages/spaces/DelegatesSpacePage'
import JobSpacePage from '../pages/spaces/JobSpacePage'
import JobPage from '../pages/spaces/JobPage'
import {
  fetchJobPage,
  fetchJobSpace,
  fetchDelegatesSpace
} from '../components/spaces'

import RequestsPage from '../pages/RequestsPage'
import { fetchRequestsForms } from '../fetch'

import TeamPage from '../pages/TeamPage'
import { fetchFullGroup } from '@inside-teams/fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { agentsAccessGuard } from '../guards'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false },
    component: () => import('../pages/events/CalendarPage')
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscription',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    component: () => import('../pages/GedPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false, middleware: agentsAccessGuard }
  },
  {
    path: '/espaces-delegue/:slug',
    name: 'DelegatesSpacePage',
    component: withFetch(DelegatesSpacePage, { size: 'xxl' })(
      fetchDelegatesSpace
    )
  },
  {
    path: '/espaces/:slug',
    name: 'JobSpacePage',
    component: withFetch(JobSpacePage, { watch: true })(fetchJobSpace),
    meta: { middleware: agentsAccessGuard }
  },
  {
    path: '/page-metier/:slug',
    name: 'JobPage',
    component: withFetch(JobPage, { size: 'xxl' })(fetchJobPage),
    meta: { middleware: agentsAccessGuard }
  },
  {
    path: '/demandes/:slug',
    name: 'RequestsPage',
    component: withFetch(RequestsPage, { watch: true })(fetchRequestsForms)
  },
  {
    path: '/annuaires/annuaire-des-agents',
    name: 'AgentsDirectoryPage',
    component: () => import('../pages/directories/AgentsDirectoryPage')
  },
  {
    path: '/annuaires/annuaire-des-delegues',
    name: 'DelegatesDirectoryPage',
    component: () => import('../pages/directories/DelegatesDirectoryPage')
  },
  {
    path: '/annuaires/annuaire-des-collectivites',
    name: 'CollectivitiesDirectoryPage',
    component: () => import('../pages/directories/CollectivitiesDirectoryPage'),
    meta: { customSlug: 'collectivities' }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'WallsListingPage',
    meta: { disabled: false, middleware: agentsAccessGuard }
  },
  {
    name: 'WallPage',
    meta: { disabled: false, middleware: agentsAccessGuard }
  },
  {
    name: 'TeamPage',
    component: withFetch(TeamPage, { size: 'xxl' })(fetchFullGroup)
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
