import { markRaw } from 'vue'

import Microsoft from '@inside-auth/components/login/extra-component/Microsoft'
import { IconText } from 'inside-collection/atoms'

import { getContentImage } from '@inside-library/helpers/Image'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  'inside-auth': {
    extraComponent: {
      is: Microsoft,
      link: `${origin}/saml/login`
    }
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'shortcuts', restrictions: ['Délégué'], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'password', restrictions: ['Agent'] },
        { name: 'subscriptions', restrictions: [], icon: 'tag' }
      ]
    },
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true
    },
    shortcuts: {
      max: 5
    },
    csvImport: true,
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/directories/UserCard'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'thumbnail')
        }),
        selectionConfig: {
          fields: [
            'uuid_host',
            'firstname',
            'lastname',
            'phone',
            'functions',
            'image'
          ],
          filters: {
            'status:eq': 1,
            sort: 'lastname:asc',
            'is_maintenance:eq': 0
          }
        },
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'functions',
          'image'
        ]
      }
    }
  },
  'inside-events': {
    bookmarkEnabled: true,
    showBookmarks: true,
    subscriptionEnabled: true
  },
  'inside-edition': {
    revisionEnabled: true
  },
  'inside-newcomers': {
    period: 90
  },
  'inside-jobs': {
    mainContentType: 'job_offers',
    modalName: 'offers',
    modalOptions: {
      size: 'm'
    },
    categoriesFields: [
      {
        type_sectors: {
          fields: ['title', 'uuid', 'color'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      }
    ],
    fields: ['uuid', 'title', 'admin', 'content_type'],
    cardOverrides: (data, { addItemAfter }) => {
      addItemAfter('contract', {
        id: 'branches',
        class: 'branches',
        tag: 'div',
        children: [
          {
            tag: markRaw(IconText),
            data: { icon: 'holidays' },
            value: data?.type_sectors?.data
              .map(typeSector => typeSector.title)
              .join(', ')
          }
        ]
      })
    }
  },
  'inside-statistics': {
    contentsWithStats: [
      'news',
      'events',
      'documents',
      'hr_space',
      'request_forms',
      'delegates_space',
      'organizations',
      'users',
      'public_services',
      'tools',
      'movements',
      'job_offers'
    ]
  },
  'inside-organizational-chart': {
    functionKey: 'functions'
  },
  'inside-workflows': {
    isEnabled: true
  }
}
