import { storage } from '@inside-library/helpers/Storage'
import { http } from '@inside-library/helpers/Http'

const isAgentUser = async () => {
  const { data } = await http.get('content/users', {
    fields: ['uuid', 'is_agent'],
    filters: { 'uuid:eq': storage.get('current-user').uuid, 'status:eq': 1 }
  })

  return data[0].is_agent
}

export { isAgentUser }
