import { http } from '@inside-library/helpers/Http'

export const fetchRequestsForms = async ({ $route }) => {
  try {
    const { data } = await http.get('content/request_forms', {
      fields: [
        'uuid',
        'title',
        'content_type',
        'admin',
        'slug',
        'banner',
        'chapo',
        {
          request_themes: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'admin',
              { request_forms: ['uuid', 'title'] }
            ],
            filters: {
              reverse: true,
              'status:eq': 1,
              sort: 'title:asc'
            }
          }
        }
      ],
      filters: {
        'slug:eq': $route.params.slug,
        'status:eq': 1
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
