import { http } from '@inside-library/helpers/Http'

import { isAgentUser } from '../../helpers/index'

const fetchJobPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/job_pages', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'banner',
        {
          grouping_pages: {
            fields: ['uuid', { hr_space: { fields: ['title', 'slug'] } }]
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    const hrSpace = data[0].grouping_pages.data[0].hr_space

    return { ...data[0], hrSpace }
  } catch (err) {
    throw new Error(err)
  }
}

const fetchJobSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/hr_space', {
      filters: { slug: $route.params.slug },
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction',
        'banner',
        'admin',
        'custom_slug',
        'show_job_offers',
        {
          key_contacts: [
            'uuid',
            'firstname',
            'lastname',
            'image',
            'functions',
            'phone',
            'is_agent'
          ]
        },
        {
          tools: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'admin',
              'icon',
              'image',
              'tools_link',
              'content',
              {
                tools_categories: [
                  'uuid',
                  { tools_categories_listings: ['uuid', 'slug'] }
                ]
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: {
              'status:eq': 1
            }
          }
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchGroupingPages = async ({ $route }) => {
  try {
    const { data } = await http.get('content/grouping_pages', {
      fields: ['uuid', 'title'],
      filters: { hr_space: { 'slug:eq': $route.params.slug } }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchDelegatesSpace = async ({ $route }) => {
  const isAgent = await isAgentUser()

  try {
    const { data } = await http.get('content/delegates_space', {
      filters: { slug: $route.params.slug },
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction',
        'banner',
        'admin',
        'custom_slug',
        {
          key_contacts: [
            'uuid',
            'firstname',
            'lastname',
            'image',
            'functions',
            'phone',
            'is_agent'
          ]
        },
        {
          content_block: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'admin',
              'icon',
              'image',
              'link',
              'link_label',
              'related_page',
              'weight'
            ],
            filters: {
              'status:eq': 1,
              sort: 'weight:asc'
            }
          }
        },
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: {
              'status:eq': 1
            }
          }
        }
      ]
    })

    const filteredBlocks = data?.[0]?.content_block?.data.filter(
      block =>
        block.related_page === 'space' ||
        block.related_page === (isAgent ? 'agents' : 'delegates')
    )

    return { ...data[0], content_block: filteredBlocks }
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchJobPage, fetchJobSpace, fetchDelegatesSpace, fetchGroupingPages }
